//TODO -
//fix layer draw order for ghost block

function placeTile(%imageMap)
{
	%pos = getNearestFourth($Player.getPosition());
	
	//t2dVectorCompare(gridGroup.getObject(%i).getPosition(), %pos)
	
	for(%i = 0; %i < gridGroup.getCount(); %i++)
	{
		if(t2dVectorCompare(gridGroup.getObject(%i).getPosition(), %pos))
		{
			if(gridGroup.getObject(%i).getImageMap() !$= %imageMap)
			{
				if(gridGroup.getObject(%i).getClassName() !$= "t2dTextObject" && !gridGroup.getObject(%i).interactive)
					gridGroup.getObject(%i).delete();
			}else{
				return;
			}
		}
	}
	createGridBlock(%imageMap, %pos);
}



function placeText(%text, %color)
{
	%pos = getNearestFourth($Player.getPosition());
	
	if(%color $= "")
		%color = "1 1 1 1";
	%size = "4 4";
	
	%obj = new t2dTextObject() {
		size = %size;
		font = "Arial";
		textAlign = "Center";
		fontSizes = "80";
		textColor = %color;
		text = %text;
	};
	$Player.getSceneGraph().addToScene(%obj);
	%obj.setPosition(%pos);
	gridGroup.add(%obj);
	
	return(%obj);
}

function updateEditorObjPosition(%obj)
{
	%pos = getNearestFourth($Player.getPosition());
	
	if(!t2dVectorCompare(%pos, %obj.getPosition()))
		%obj.setPosition(%pos);
}

function removeTile()
{
	%pos = getNearestFourth($Player.getPosition());
	%list = $Player.scenegraph.pickPoint(getWord(%pos, 0), getWord(%pos, 1), BIT(0) | BIT(1) | BIT(2), -1, 0, $Player);
	
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		%obj.delete();
	}
}

function saveLevel(%val)
{
	if(!%val)
		return;
	
	%file = new FileObject();
	%file.openForWrite("./levels/test.txt");
	for(%i = 0; %i < gridGroup.getCount(); %i++)
	{
		%obj = gridGroup.getObject(%i);
		if(%obj.getClassName() $= "t2dTextObject")
		{
			%file.writeLine("Text" SPC %obj.getPosition() SPC %obj.textColor SPC %obj.text);
		}else{
			%file.writeLine(%obj.getImageMap() SPC %obj.getPosition());
		}
	}
	
	%file.close();
	
	floatingMessage($Player.getPosition(), "Saved!", "5 5");
}

//copy to clipboard
function copyLevelToClipboard(%val)
{
	if(!%val)
		return;
		
	for(%i = 0; %i < gridGroup.getCount(); %i++)
	{
		%obj = gridGroup.getObject(%i);
		if(%obj.getClassName() $= "t2dTextObject")
		{
			%str = %str @ "Text" SPC %obj.getPosition() SPC %obj.textColor SPC %obj.text @ "\n";
		}else{
			%str = %str @ %obj.getImageMap() SPC %obj.getPosition() @ "\n";
		}
	}
	setClipboard(%str);
	floatingMessage($Player.getPosition(), "Copied to clipboard!");
}

//RANDOM SPINNING FUNCTION WOO
function spin(%val)
{
	if(!%val)
	{
		cancel($spinning);
		$doingSpecialAnimation = 0;
		return;
	}
	
	$doingSpecialAnimation = 1;
	$spin = 0;
	$spinSpeed = 45;
	$Player.setImageMap("Player_Down1ImageMap");
	$spinning = schedule(80, 0, "nextSpin");
}

function nextSpin()
{
	if($spin == 7)
		$Player.setImageMap("Player_Down1ImageMap");
		
	if($spin == 6)
		$Player.setImageMap("Player_DownRight1ImageMap");
		
	if($spin == 5)
		$Player.setImageMap("Player_Right1ImageMap");
		
	if($spin == 4)
		$Player.setImageMap("Player_UpRight1ImageMap");
		
	if($spin == 3)
		$Player.setImageMap("Player_Up1ImageMap");
		
	if($spin == 2)
		$Player.setImageMap("Player_UpLeft1ImageMap");
		
	if($spin == 1)
		$Player.setImageMap("Player_Left1ImageMap");
		
	if($spin == 0)
		$Player.setImageMap("Player_DownLeft1ImageMap");
	
	$spin++;
	if($spin > 7)
		$spin = 0;
	$spinning = schedule($spinSpeed, 0, "nextSpin");
}

function createGhost(%imageMap)
{
	if(%imageMap $= "")
		%imageMap = "grassImageMap";
	
	if(isObject($ghostBlock))
	{
		$movingGhostBlock = 0;
		$ghostBlock.delete();
	}
	
	%cursorPos = sceneWindow2D.getWorldPoint(canvas.getCursorPos());
	%pos = getNearestFourth(%cursorPos);
	
	%obj = new t2dStaticSprite()
	{
		scenegraph = $Player.scenegraph;
		size = "4 4";
		position = %pos;
		imageMap = %imageMap;
		layer = 1;
	};
	%obj.setBlendColour("0.8 0.8 0.8 0.8");
	//%obj.setPosition(%pos);
	
	$ghostBlock = %obj;
	$movingGhostBlock = 1;
	//updateGhostPosition();
}

function updateGhostPosition()
{
	%obj = $ghostBlock;
	%cursorPos = sceneWindow2D.getWorldPoint(canvas.getCursorPos());
	%pos = getNearestFourth(%cursorPos);
	
	%obj.setPosition(%pos);
	
	$ghostUpdateSched = schedule(25, 0, "updateGhostPosition");
}

function getNearestFourth(%pos)
{
	%posX = getWord(%pos, 0) / 4;
	%posY = getWord(%pos, 1) / 4;
	
	%posX = mRound(%posX) * 4;
	%posY = mRound(%posY) * 4;
	%pos = %posX SPC %posY;
	
	return(%pos);
}

function sceneWindow2D::onMouseMove(%this, %mod, %worldPos, %mouseClicks)  
{
	if($movingGhostBlock && isobject($ghostBlock))
	{
		$ghostBlock.setPosition(getNearestFourth(%worldPos));
	}
}

function sceneWindow2D::onMouseDragged(%this, %mod, %worldPos, %mouseClicks)  
{
	if($movingGhostBlock && isObject($ghostBlock))
	{
		$ghostBlock.setPosition(getNearestFourth(%worldPos));
		//place tile code here
		placeTileAtPos($ghostBlock.getImageMap(), $ghostBlock.getPosition());
	}
}

function sceneWindow2D::onMouseDown(%this, %mod, %worldPos, %mouseClicks)  
{
	if($movingGhostBlock && isObject($ghostBlock))
	{
		//place tile code here
		placeTileAtPos($ghostBlock.getImageMap(), $ghostBlock.getPosition());
	}
}
  
//function sceneWindow2D::onMouseUp(%this, %mod, %worldPos, %mouseClicks)  
//{
	
//}

function sceneWindow2D::onRightMouseDown(%this, %mod, %worldPos, %mouseClicks)  
{
	%x = getWord(%worldPos, 0);
	%y = getWord(%worldPos, 1);
	%list = $Player.scenegraph.pickPoint(%x, %y, BIT(0) | BIT(1) | BIT(2), -1, 0, $Player);
	
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		if(%obj != $ghostBlock && %obj != $Player)
			%obj.delete();
	}
}

function sceneWindow2D::onRightMouseDragged(%this, %mod, %worldPos, %mouseClicks)  
{
	%x = getWord(%worldPos, 0);
	%y = getWord(%worldPos, 1);
	%list = $Player.scenegraph.pickPoint(%x, %y, BIT(0) | BIT(1) | BIT(2), -1, 0, $Player);
	
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		%obj.delete();
	}
}

function placeTileAtPos(%imageMap, %pos)
{
	%pos = getNearestFourth(%pos);
	%list = $Player.scenegraph.pickPoint(getWord(%pos, 0), getWord(%pos, 1), BIT(0) | BIT(1) | BIT(2), -1, 0, $Player);
	
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		if(%obj != $ghostBlock)
		{
			if(%obj.getImageMap() !$= %imageMap)
			{
				if(%obj.getClassName() !$= "t2dTextObject" && !%obj.interactive)
					%obj.delete();
			}else{
				return;
			}
		}
	}
	
	//for(%i = 0; %i < gridGroup.getCount(); %i++)
	//{
	//	if(t2dVectorCompare(gridGroup.getObject(%i).getPosition(), %pos))
	//	{
	//		if(gridGroup.getObject(%i).getImageMap() !$= %imageMap)
	//		{
	//			if(gridGroup.getObject(%i).getClassName() !$= "t2dTextObject" && !gridGroup.getObject(%i).interactive)
	//				gridGroup.getObject(%i).delete();
	//		}else{
	//			return;
	//		}
	//	}
	//}
	createGridBlock(%imageMap, %pos);
}

function removeTileAtPos(%pos)
{
	%pos = getNearestFourth(%pos);
	%list = $Player.scenegraph.pickPoint(getWord(%pos, 0), getWord(%pos, 1), BIT(0) | BIT(1) | BIT(2), -1, 0, $Player);
	
	for(%i = 0; %i < getWordCount(%list); %i++)
	{
		%obj = getWord(%list, %i);
		if(%obj != $ghostBlock)
			%obj.delete();
	}
}
